use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInventoryItemsTable extends Migration
{
    public function up()
    {
        Schema::create('inventory_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->date('use_by_date');
            $table->decimal('wholesale_price', 10, 2);
            $table->integer('minimum_order_quantity');
            $table->integer('available_quantity');
            $table->boolean('dutch_auction_enabled')->default(false);
            $table->decimal('dutch_initial_price', 10, 2)->nullable();
            $table->decimal('dutch_floor_price', 10, 2)->nullable();
            $table->enum('dutch_decrement_type', ['amount', 'percentage'])->nullable();
            $table->decimal('dutch_decrement_value', 10, 2)->nullable();
            $table->integer('dutch_decrement_frequency_days')->default(1)->nullable();
            $table->decimal('current_price', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('inventory_items');
    }
}